ace.define("ace/mode/pxplus_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var PxPlusHighlightRules = function() {

    /* Rules to exclude keywords when used as variable/property names or function/method names */
    var notVarOrFuncLookBehind = "(?<!(?:\\bfunction\\b.+|,|\\(|\\=\\*?|\\+|-|\\*|\\\/|\\^|\\>|\\<|\\band|\\bor|\\[|\\bnext|\\breturn|\\bpreinput)\\s*|'|\\.)"
    var notVarOrFuncLookAhead = "(?!:|\\$|\\s*(?:,|\\)|\\=|\\+|-|\\\/|\\^|\\>|\\<|and\\b|or\\b))"

    this.$rules = {
    "start": [
        {
            token: [
                "meta.ending-space"
            ],
            regex: "$"
        },
        {
            token: [
                null
            ],
            regex: "^(?=\\t)",
            next: "state_3"
        },
        {
            token: [null],
            regex: "^(?= )",
            next: "state_4"
        },
        {
            token: "punctuation.definition.comment",
            regex: "REM ",
            next: "comment",
            caseInsensitive: true
        },
		{
            token: "punctuation.definition.comment",
            regex: "(?<!')!.*",
            caseInsensitive: true
        },
        {
            token: "meta.tag",
            regex: "(?<=^\\d+\\s+|^\\s*)\\w+\\s*:\\s*(?=\\\\?$)",
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind+
			"\\b(?:accept|add|and|auto|begin|break|call|case|catch|class|clear|close|continue|control|create|data|def|default|"+
			"defctl|delete|dictionary|directory|disable|drop|edit|else|enable|end|end_if|end_try|error_handler|escape|event|except|"+
			"exit|exitto|file|finally|find|for|from|get|gosub|goto|hide|if|index|indexed|input|list|load|lock|merge|"+
			"next(?:\\s+record)?|object|off|on|open|perform|pop|preinput|print|process|program|properties|purge|quit|read|record|"+
			"release|remove|repeat|required|reset|restore|retry|return|run|same|save|select|server|set|set_focus|show|start|static|"+
			"step|stop|swap|switch|table|then|time|to|unique|unlock|until|wait|wend|where|while|window(?:\\+|,)?|with|write)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\*","")+
			"\\b(?:from)\\b"+
			notVarOrFuncLookAhead,
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\bpreinput","")+
			"\\b(?:next(?:\\s+record)?)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("\\bfunction\\b.+","\\)")+
			"\\b(?:for\\s+event|hide|local)\\b"+
			notVarOrFuncLookAhead,
            caseInsensitive: true
        },
        {
            token: [
                "keyword.control"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\(","")+
			"\\b(?:ctl|err|key|try)\\b"+
			notVarOrFuncLookAhead.replace("|//)","|//(|//)"),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.directive"
            ],
			regex: notVarOrFuncLookBehind.replace("|\\(","")+
			"\\b(?:accept|add|addr|auto|begin|button|bye|chart|check_box|clear|clip_board|close|create|custom_vbx|cwdir|data|"+
			"day_format|def|defctl|defprt|deftty|delete|dictionary|direct|directory|disable|drop|drop_box|dump|enable|endtrace|"+
			"enter|erase|error_handler|execute|extract|file|find|floatingpoint|flush|function|get_file_box|grid|h_scrollbar|"+
			"hide|indexed|insert|invoke|iolist|keyed|let|like|line_switch|list|list_box|load|local|lock|long_form|menu_bar|merge|"+
			"message_lib|mnemonic|msgbox|multi_line|multi_media|obtain|on|open(?:\\+)?|password|perform|pop|popup_menu|precision|"+
			"prefix|preinput|print|process|program|property|purge|radio_button|randomize|read|redim|refile|release|remove|rename|"+
			"renumber|reset|restore|round|save|serial|set_focus|set_param|setctl|setday|setdrive|seterr|setesc|setfid|setmouse|"+
			"settime|settrace|short_form|show|sort|static|system_help|system_jrnl|table|translate|tristate_box|unlock|update|"+
			"user_lex|v_scrollbar|vardrop_box|varlist_box|via|video_palette|wait|winprt_setup|with|write)\\b"+
			notVarOrFuncLookAhead.replace("|-",""),
            caseInsensitive: true
        },
        {
            token: [
                "keyword.directive"
            ],
			regex: notVarOrFuncLookBehind+
			"\\b(?:dim)\\b"+
			notVarOrFuncLookAhead.replace("|//)","|//(|//)"),
            caseInsensitive: true
        },
        {
            token: "keyword.operator",
            regex: "\\b(?:And|Or)\\b",
            caseInsensitive: true
        },
        {
            token: "punctuation.definition.string.begin",
            regex: '"',
            next: "string"
        },
        {
            token: "punctuation.definition.string.hexstring",
            regex: '\\$([0-9A-Fa-f][0-9A-Fa-f])*\\$',
        },
        {
            token: "punctuation.definition.string.mnemonic",
            regex: "(?<=set_param\\s+|prm\\s*\\(\\s*)-?\\s*'..'",
        },
        {
            token: "punctuation.definition.string.mnemonic",
            regex: "(?<![a-zA-Z_][a-zA-Z0-9_]*)'_?[a-zA-Z0-9+\\-]+'(?![a-zA-Z_][a-zA-Z0-9_]*)",
        },
        {
            token: "support.function",
            regex: "(?<!(?:\\bfunction\\b.+)\\s*|'|\\.)"+
			"(?:@|@x|@y|\\b(?:Abs|Acs|And|Arg|Asc|Asn|Ath|Atn|Bin|Bsz|Chg|Chr|Cmp|Cos|Cpl|Crc|Cse|Ctl|Cvs|Dec|Deg|Dim|Dir|Dll|Dlx|"+
			"Dsk|Dte|Env|Ept|Err|Evn|Evs|Exp|Ffn|Fib|Fid|Fin|Fpt|Gap|Gbl|Gep|Hsa|Hsh|Hta|Hwn|I3E|I86|Ind|Int|Iol|Ior|Jst|Jul|Kec|"+
			"Kef|Kel|Ken|Kep|Key|Kgn|Lcs|Len|Lno|Log|Lrc|Lst|Max|Mem|Mid|Min|Mnm|Mod|Msg|Msk|Mxc|Mxl|New|Not|Nul|Num|Obj|Opt|Pad|"+
			"Pck|Pfx|Pgm|Pos|Prc|Prm|Pth|Pub|Rad|Rcd|Rdx|Rec|Ref|Rnd|Rno|Sep|Sgn|Sin|Sqr|Srt|Ssz|Stk|Stp|Str|Sub|Swp|Sys|Tan|Tbl|"+
			"Tcb|Tmr|Trx|Try|Tsk|Txh|Txw|Ucp|Ucs|Upk|Vin|Vis|Xeq|Xfa|Xml|Xor)\\b)"+
			"(?=\\s*\\(\\)?)",
            caseInsensitive: true
        },
        {
            token: [
                "constant.numeric"
            ],
            regex: "\\.?\\b(?:(?:0(?:x|X)[0-9a-fA-F]*)|(?:[0-9]+\\.?[0-9]*)(?:(?:e|E)(?:\\+|-)?[0-9]+)?)(?:L|l|UL|ul|u|U|F|f)?\\b"
        },
        {
            token: [
                "entity.name.function"
            ],
            regex: "(?:(\\b[a-zA-Z_x7f-xff][a-zA-Z0-9_x7f-xff]*?\\b\\$?)(?=\\s*\\(\\)?))"
        },
        {
            token: [
                "keyword.operator"
            ],
            regex: "\\-|\\+|\\*|\\\/|\\>|\\<|\\=|\\&"
        }
    ],
    "state_3": [
        {
            token: [
                "meta.odd-tab.tabs",
                "meta.even-tab.tabs"
            ],
            regex: "(\\t)(\\t)?"
        },
        {
            token: "meta.leading-space",
            regex: "(?=[^\\t])",
            next: "start"
        },
        {
            token: "meta.leading-space",
            regex: ".",
            next: "state_3"
        }
    ],
    "state_4": [
        {
            token: ["meta.odd-tab.spaces", "meta.even-tab.spaces"],
            regex: "(  )(  )?"
        },
        {
            token: "meta.leading-space",
            regex: "(?=[^ ])",
            next: "start"
        },
        {
            defaultToken: "meta.leading-space"
        }
    ],
    "comment": [
        {
            token: "comment.line.apostrophe",
            regex: "$|(?=(?:%>))",
            next: "start"
        },
        {
            defaultToken: "comment.line.apostrophe"
        }
    ],
    "string": [
        {
            token: "constant.character.escape.apostrophe",
            regex: '""'
        },
        {
            token: "string.quoted.double",
            regex: '"',
            next: "start"
        },
        {
            defaultToken: "string.quoted.double"
        }
    ]
}

};

oop.inherits(PxPlusHighlightRules, TextHighlightRules);

exports.PxPlusHighlightRules = PxPlusHighlightRules;
});

ace.define("ace/mode/pxplus",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/pxplus_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var PxPlusHighlightRules = require("./pxplus_highlight_rules").PxPlusHighlightRules;

var Mode = function() {
    this.HighlightRules = PxPlusHighlightRules;
};
oop.inherits(Mode, TextMode);

(function() {
       
    this.lineCommentStart = ["!", "REM"];
    
    this.$id = "ace/mode/pxplus";
}).call(Mode.prototype);

exports.Mode = Mode;
});
